#include <iostream>
#include <cstring>
#include "squares.h"
#include "utils.h"
#include "log.h"


using namespace std;


const uint castlebits[BRDSQ] = {
11	,	15	,	15	,	15	,	3	,	   15	,	15	,	7	,	0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,  15,	0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,	15, 0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,	15, 0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,	15, 0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,  15,	0,0,0,0,0,0,0,0,
15	,	15	,	15	,	15	,	15	,	15	,	15	,  15,	0,0,0,0,0,0,0,0,
14	,	15	,	15	,	15	,	12	,	15	,	15	,	13, 0,0,0,0,0,0,0,0
};
const string sqrstr[BRDSQ] ={
"a1","b1","c1","d1","e1","f1","g1","h1","?","?","?","?","?","?","?","?",
"a2","b2","c2","d2","e2","f2","g2","h2","?","?","?","?","?","?","?","?",
"a3","b3","c3","d3","e3","f3","g3","h3","?","?","?","?","?","?","?","?",
"a4","b4","c4","d4","e4","f4","g4","h4","?","?","?","?","?","?","?","?",
"a5","b5","c5","d5","e5","f5","g5","h5","?","?","?","?","?","?","?","?",
"a6","b6","c6","d6","e6","f6","g6","h6","?","?","?","?","?","?","?","?",
"a7","b7","c7","d7","e7","f7","g7","h7","?","?","?","?","?","?","?","?",
"a8","b8","c8","d8","e8","f8","g8","h8","?","?","?","?","?","?","?","?"
};

const string ranktostr = "12345678";
const string filetostr = "abcdefgh";

const int rankrev[8] = { RANK8, RANK7, RANK6, RANK5, RANK4, RANK3, RANK2, RANK1 };

uint fr2sq(uint f, uint r)
{
    ASS(f>=FILEA && f <=FILEH);
    ASS(r>=RANK1 && r<= RANK8);
    return (f  + (r * 16));
}

string printsquare(uint sq)
{
    ASS(sq>=0&&sq<128);
    return sqrstr[sq];
}

uint str2sq(string sq)
{
    for (uint i = 0; i < BRDSQ; ++i)
    {
        if(sqrstr[i][0] == sq[0] && sqrstr[i][1] == sq[1]) return i;
    }
    return BRDSQ;//illegal
}


uint  chartofile (const char file)
{
       if (file == 'a') {return FILEA;}
       else if (file == 'b') {return FILEB;}
       else if (file == 'c') {return FILEC;}
       else if (file == 'd') {return FILED;}
       else if (file == 'e') {return FILEE;}
       else if (file == 'f') {return FILEF;}
       else if (file == 'g') {return FILEG;}
       else if (file == 'h') {return FILEH;}
       else {cout<<"file error "<<file<<" ";ASS(true==false);}

	   return 9;
}

uint   chartorank(const char rank)
{
       if (rank == '1') {return RANK1;}
       else if (rank == '2') {return RANK2;}
       else if (rank == '3') {return RANK3;}
       else if (rank == '4') {return RANK4;}
       else if (rank == '5') {return RANK5;}
       else if (rank == '6') {return RANK6;}
       else if (rank == '7') {return RANK7;}
       else if (rank == '8') {return RANK8;}
       else {cout<<"rank error "<<rank<<" ";ASS(true==false);}
	   return 9;
}
